<?php
function inverse_byte_order($a)
{
	$res=0;
	$res += (($a & 0xff) <<24) & 0xff000000;
	$res += (($a & 0xff00) <<8) & 0xff0000;
	$res += (($a & 0xff0000) >>8) & 0xff00;
	$res += (($a & 0xff000000) >>24) & 0xff;
	return $res;
}
	
class UberString
{
	public $str;
	private $len;
	
	public function __construct($str){
		$this->str = $str;
		$this->len = strlen($str);
	}
	public function countInt(){return strlen($this->str)/4;}
	
	//tous les offsets sont en octets
	public function intOffsetExists($i){return $i < (strlen($this->str)/4);}

	public function getInt($i){
		$s=&$this->str;
		$res=0;
		//$i*=4;
		for($j=3; $j >= 0 ; $j--)
		{
			$res *= 256;
			$res += ord($s[$i+$j]);
		}
		return $res;
	}
	public function setInt($i,$a){
		$s=&$this->str;
		$s[$i]=chr($a & 0xff);
		$s[1+$i]=chr(($a & 0xff00)>>8);
		$s[2+$i]=chr(($a & 0xff0000)>>16);
		$s[3+$i]=chr(($a & 0xff000000)>>24);
	}
	public function countByte(){return strlen($this->str);}

	public function byteOffsetExists($i){return $i < strlen($this->str);}
	
	public function getByte($i){return ord($this->str[$i]);}
	public function setByte($i,$a){$this->str[$i] = chr($a);}
	
	public function __toString(){
		return bin2hex($this->str)."\r\n";
	}
}

class ArrayObjectIterator implements Iterator
{
	private $a;
	private $k;
	private $n;
	
	public function __construct($a)
	{
		$this->a = $a;
		$this->k = 0;
		$this->n = $a->count();
	}
	public function count(){return $this->n;}
	public function rewind(){$this->k=0;}
	public function key(){return $this->k;}
	public function current(){return $this->a[$this->k];}
	public function next(){$this->k++;}
	public function valid(){return $this->k < $this->n;}
}

class IntPtr extends ArrayObject
{
	public $uber;
	//le shift est en octets
	public $shift;
	
	public function __construct($uber,$shift=0){
		$this->uber = $uber;
		$this->shift=$shift;
	}

	public function getIterator(){return new ArrayObjectIterator($this);}
	public function count(){return $this->uber->countInt();}
	public function offsetExists($i){return $this->uber->intOffsetExists($this->shift+$i*4);}
	public function offsetGet($i){return $this->uber->getInt($this->shift+$i*4);}
	public function offsetSet($i,$a){return $this->uber->setInt($this->shift+$i*4,$a);}
}
class BytePtr extends ArrayObject
{
	public $uber;
	//le shift est en octets
	public $shift;
	
	public function __construct(&$uber,$shift=0){
		$this->uber = $uber;
		$this->shift=$shift;
	}
	public function getIterator(){return new ArrayObjectIterator($this);}

	public function count(){return $this->uber->countByte();}

	public function offsetExists($i){return $this->uber->byteOffsetExists($i);}
	
	public function offsetGet($i){return $this->uber->getByte($i+$this->shift);}
	public function offsetSet($i,$a){return $this->uber->setByte($i+$this->shift,$a);}
}