<?php
function lshiftright($var,$amt)
{
$mask = 0x40000000;
if($var < 0)
{
$var&=0x7FFFFFFF;
$mask=$mask>>($amt-1);
return ($var>>$amt)|$mask;
}
return $var >> $amt;
}
function _BF_SHR32($x,$bits)
{
if($bits==0) return $x;
if($bits==32) return 0;
$y=($x&0x7FFFFFFF)>>$bits;
if(0x80000000 & $x){
$y |= (1<<(31-$bits));   
}
return $y;
}
function _BF_SHL32($x,$bits)
{
if ($bits==0) return $x;
if ($bits==32) return 0;
$mask = (1<<(32-$bits)) - 1;
return (($x & $mask) << $bits) & 0xFFFFFFFF;
}
function _BF_GETBYTE($x,$y){return _BF_SHR32($x,8*$y)&0xFF;}
function _BF_OR32($x,$y){return ($x|$y)&0xFFFFFFFF;}
function _BF_ADD32($x,$y)
{
   $x = $x&0xFFFFFFFF;
   $y = $y&0xFFFFFFFF;

   $total=0;
   $carry=0;
   for($i=0;$i<4;$i++){
       $byte_x = _BF_GETBYTE($x, $i);
       $byte_y = _BF_GETBYTE($y, $i);
       $sum = $byte_x + $byte_y;

       $result = $sum & 0xFF;
       $carryforward = _BF_SHR32($sum, 8);

       $sum = $result + $carry;
       $result = $sum & 0xFF;
       $carry = $carryforward + _BF_SHR32($sum, 8);

       $total = _BF_OR32(_BF_SHL32($result, $i*8), $total);
   }

   return $total;
}

//void encshare2(unsigned int *tbuff, unsigned int *tbuffp, int len) {
function encshare2(&$tbuff, &$tbuffp, $len){
	
	$t2 = $tbuff[304];
	$t1 = $tbuff[305];
	$t3 = $tbuff[306];
	$t5 = $tbuff[307];

	//$limit = $tbuffp + $len;
	$i=0;
	$j=0;
	$p = new IntPtr($tbuff->uber);
	
	while($i < $len) {
		//p = tbuff + t2 + 272;
		//que des pointeurs int
		$p->shift = $tbuff->shift + $t2*4 + 272*4;
		while($t5 < 65536) {
			$t1 = _BF_ADD32($t1,$t5);
			//p++;
			$p->shift += 4;
			
			$t3 = _BF_ADD32($t3,$t1);
			$t1 = _BF_ADD32($t1,$t3);

			$p[-17] = $t1;
			$p[-1] = $t3;
			$t4 = ($t3 << 24) | lshiftright($t3 , 8);
			
			$p[15] = $t5;
			$t5 = _BF_SHL32($t5, 1);
			//$t2++;
			$t2 = _BF_ADD32($t2,1);
			
			$t1 ^= $tbuff[$t1 & 0xff];
			$t4 ^= $tbuff[$t4 & 0xff];
			
			$t3 = ($t4 << 24) | lshiftright($t4 , 8);

			$t4 = lshiftright($t1 , 24) | ($t1 << 8);
			$t4 ^= $tbuff[$t4 & 0xff];
			$t3 ^= $tbuff[$t3 & 0xff];

			$t1 = lshiftright($t4 , 24) | ($t4 << 8);
		}
		$t3 ^= $t1;
		//*tbuffp++ = t3;

		$tbuffp[$i++] = $t3;
		
		$t2--;

		$t1 = $tbuff[_BF_ADD32($t2 , 256)];
		$t5 = $tbuff[_BF_ADD32($t2 , 272)];
		$t1 = ~$t1;

		$t3 = ($t1 << 24) | lshiftright($t1 , 8);

		$t3 ^= $tbuff[$t3 & 0xff];
		$t5 ^= $tbuff[$t5 & 0xff];
		$t1 = ($t3 << 24) | lshiftright($t3 , 8);

		$t4 = lshiftright($t5 , 24) | ($t5 << 8);

		$t1 ^= $tbuff[$t1 & 0xff];
		$t4 ^= $tbuff[$t4 & 0xff];
		
		$t3 = lshiftright($t4 , 24) | ($t4 << 8);

		$t5 = _BF_ADD32(($tbuff[_BF_ADD32($t2 , 288)] << 1), 1);
	}
	$tbuff[304] = $t2;
	$tbuff[305] = $t1;
	$tbuff[306] = $t3;
	$tbuff[307] = $t5;
}


//void encshare1(unsigned int *tbuff, unsigned char *datap, int len) {
function encshare1($tbuff, $datap, $len){

    //p = s = (unsigned char *)(tbuff + 309);
	$p = new BytePtr($tbuff->uber,$tbuff->shift + 309*4);
	$s = new BytePtr($tbuff->uber,$tbuff->shift + 309*4);
    
    $datap1 = new BytePtr($datap->uber,$datap->shift);

	encshare2($tbuff, new IntPtr($p->uber,$p->shift), 16);

	$len1=$len;
	
	while($len--) {
	
		//if((p - s) == 63) {
		if(($p->shift - $s->shift) == 63) {
			//p=s;
			$p->shift = $s->shift;
			//encshare2(tbuff, (unsigned int *)p, 16);
			encshare2($tbuff, new IntPtr($p->uber,$p->shift), 16);
		}
		//*datap ^= *p;
		$datap1[0] ^= $p[0];
		//datap++;
		$datap1->shift++;
		//p++;
		$p->shift++;
	}
	
}


//void encshare3(unsigned int *data, int n1, int n2) {
function encshare3(&$data,$n1, $n2) {

	$t2 = $n1;
	$t1 = 0;
	$t4 = 1;
	$data[304] = 0;
	

	for($i = 32768; $i; $i >>= 1){
		//$t2 +=$t4;
		$t2 = _BF_ADD32($t2,$t4);
		
		//$t1 += $t2;
		$t1 = _BF_ADD32($t1,$t2);
		
		//$t2 += $t1;
		$t2 = _BF_ADD32($t2,$t1);

		if($n2 & $i) {
			$t2 = ~$t2;
			$t4 = ($t4 << 1) + 1;
			$t3 = ($t2 << 24) | lshiftright($t2 , 8);
			$t3 ^= $data[$t3 & 0xff];
			$t1 ^= $data[$t1 & 0xff];
			$t2 = ($t3 << 24) | lshiftright($t3 , 8);
			$t3 = lshiftright($t1 , 24) | ($t1 << 8);
			$t2 ^= $data[$t2 & 0xff];
			$t3 ^= $data[$t3 & 0xff];
			$t1 = lshiftright($t3 , 24) | ($t3 << 8);
		}
		else{
			$data[$data[304] + 256] = $t2;
			$data[$data[304] + 272] = $t1;
			$data[$data[304] + 288] = $t4;
			$data[304] = $data[304] + 1;
			$t3 = ($t1 << 24) | lshiftright($t1 , 8);
				
			$t2 ^= $data[$t2 & 0xff];
			$t3 ^= $data[$t3 & 0xff];
			$t1 = ($t3 << 24) | lshiftright($t3 , 8);
			
			$t3 = lshiftright($t2 , 24) | ($t2 << 8);
			
			$t3 ^= $data[$t3 & 0xff];
			$t1 ^= $data[$t1 & 0xff];
			$t2 = (lshiftright($t3,24)) | ($t3 << 8);
			
			$t4 <<= 1;
		}
	}
	$data[305] = $t2;
	$data[306] = $t1;
	$data[307] = $t4;
	$data[308] = $n1;
}


//void encshare4(unsigned char *src, int size, unsigned int *dest) {
function encshare4($src,$size,&$dest){
	
	for($i = 0; $i < 256; $i++)	 $dest[$i] = 0;
	
	for($y = 0; $y < 4; $y++) {
		
		for($i = 0; $i < 256; $i++)	$dest[$i] = (($dest[$i] << 8) + $i)&0xffffffff;
	
		for($pos = $y, $x = 0; $x < 2; $x++){
			for($i = 0; $i < 256; $i++) {
				$tmp = $dest[$i];
				
				$pos = ($pos + $tmp + $src[$i % $size]) & 0xff;
			
				$dest[$i] = $dest[$pos];
				$dest[$pos] = $tmp;
			}
		}
	}
	for($i = 0; $i < 256; $i++) $dest[$i] ^= $i;
	
	encshare3($dest, 0, 0);
}


