/*
    Copyright 2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#ifdef WIN32
    typedef unsigned char   u_char;
    typedef unsigned short  u_short;
    typedef unsigned int    u_int;
#endif

typedef struct {
    u_int   from;           // download from byte
    u_int   tot;            // download tot bytes
    int     showhead;       // show the http header and stop            (1 = yes, 0 = no)
    int     resume;         // resume a download                        (1 = yes, 0 = no)
    int     onlyifdiff;     // download only if differs from local file (1 = yes, 0 = no)
    u_char  *user;          // username for authentication
    u_char  *pass;          // password for authentication
    u_char  *referer;       // referer string
    u_char  *useragent;     // user-agent string
    u_char  *cookie;        // cookie string
    u_char  *more_http;     // additional http parameters
    int     verbose;        // verbosity (-1 = quiet, 0 = normal, 1 = verbose)
    u_char  **filedata;     // use it if you want to store the downloaded file in memory
    int     download_now;   // doesn't check for additional info
} mydown_options;



u_int mydown(               // ret: file size
    u_char  *myurl,         // the URL
                            // can be like http://aluigi.org/mytoolz/mydown.zip
                            // or http://user:pass@host:port/blabla/blabla.php?file=1
    u_char  *filename,      // NULL for automatic filename or forced like "test.txt"
    mydown_options *opt     // the above structure for your options
);


u_int mydown_http2file(     // ret: file size
    int     download,       // 0 for getting info, 1 for downloading
    u_char  *host,          // hostname or IP
    u_short port,           // port
    u_char  *user,          // username
    u_char  *pass,          // password
    u_char  *referer,       // Referer
    u_char  *useragent,     // User-Agent
    u_char  *cookie,        // Cookie
    u_char  *more_http,     // additional http parameters (ex: mycookie: blabla\r\npar: val\r\n)
    int     verbose,        // verbose
    u_char  *getstr,        // URI
    FILE    *fd,            // file descriptor
    u_char  **filename,     // filename retrieving, only for download 0
    int     showhead,       // show headers
    u_int   from,           // download from byte
    u_int   tot,            // download tot bytes
    u_int   *filesize,      // for storing file size
    u_char  **filedata      // use it if you want to store the downloaded file in memory
);


