/*
    Copyright 2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#define GSWHTTP         "HTTP/1.1 200 OK\r\n" \
                        "Connection: close\r\n" \
                        "Content-Type: text/html\r\n" \
                        "\r\n"
#define GSWCFG          "gsweb.cfg"
#define GSWFONTSZ       11
#define GSWQUERYSZ      512
#define DETECTSZ        300
#define GSWDEFTIMEOUT   3
#define GSWFILTERSZ     128
#define HTTPAMP         "&amp;" // & or &amp;

#define GSWSEND(x)      send(sock, x, sizeof(x) - 1, 0)



#ifdef WINTRAY
    #include "gswtray.h"
    #define EXESHOW SW_SHOW
#endif



int         gsw_allow_refresh = 1;  /* options */
u_char      *gsw_admin_IP     = NULL;



gsw_data_t      *gsw_data;
gsw_fav_data_t  *gsw_fav_data;
uint32_t    gsw_msip;
int         gsw_tot,
            gsw_fav_tot,
            gsw_maxping,
            gsw_noping,
            gsw_maxservers,
            gsw_font_size;
u_char      *gsw_player,
            *gsw_filter;        // temporary



int gsw_get_query_for_game(u_char *game) {
    int     i;

    for(i = 0; i < gsw_tot; i++) {
        if(!strcmp(gsw_data[i].game, game)) return(gsw_data[i].query);
    }

    return(0);
}



u_char *gsw_calc_query(u_char *buff, int type) {
    int     i;
    u_char  *p,
            *query;

    p = buff;
    p += sprintf(p, "<select name=\"query\">");

    for(i = 0; (query = switch_type_query(i, NULL, NULL, NULL, 3)); i++) {
        p += sprintf(p,
            "<option value=\"%d\"%s>%s",
            i,
            (i == type) ? " selected" : "",
            query);
    }
    strcpy(p, "</select>");

    return(buff);
}



void gsw_apply_font(int size) {
    u_char  *p;

    p = (u_char *)stristr(gsw_skin_head, "font-size:");
    if(p) {
        p[10] = (size / 10) + '0';
        p[11] = (size % 10) + '0';
    }
    gsw_font_size = size;
}



void gsweb_initconf(void) {
    fprintf(fdout, "- resolv %s ... ", ms);
    gsw_msip = resolv(ms);
    fprintf(fdout, "%s\n", inet_ntoa(*(struct in_addr *)&gsw_msip));

    gsw_player        = strdup("player");
    gsw_tot           = 0;
    gsw_fav_tot       = 0;
    gsw_filter        = strdup("");
    gsw_data          = NULL;
    gsw_fav_data      = NULL;
    gsw_maxping       = GSWDEFTIMEOUT;
    gsw_noping        = 0;
    gsw_maxservers    = 0;
    gsw_apply_font(GSWFONTSZ);
    gsw_refresh.game  = NULL;
    gsw_refresh.buff  = NULL;
    gsw_refresh.len   = 0;
}



void gsweb_saveconf(void) {
    FILE    *fd;
    int     i;

    fd = gslfopen(GSWCFG, "wb");
    if(!fd) std_err();

    fprintf(fd, "player=%s\n",     gsw_player);         /* player */

    for(i = 0; i < gsw_tot; i++) {                      /* game */
        fprintf(fd, "game=%s;%s;%s;%s;%d;%s\n",
            gsw_data[i].game,
            gsw_data[i].key,
            gsw_data[i].full,
            gsw_data[i].path,
            gsw_data[i].query,
            gsw_data[i].filter);
    }

    for(i = 0; i < gsw_fav_tot; i++) {                  /* favorite */
        fprintf(fd, "fav=%s;%s;%hu;%s\n",
            gsw_fav_data[i].game,
            inet_ntoa(*(struct in_addr *)&gsw_fav_data[i].ip),
            gsw_fav_data[i].port,
            gsw_fav_data[i].pass);
    }

    fprintf(fd, "maxping=%d\n",    gsw_maxping);        /* ping */
    fprintf(fd, "noping=%d\n",     gsw_noping);         /* noping */
    fprintf(fd, "maxservers=%d\n", gsw_maxservers);     /* maxservers */
    fprintf(fd, "font_size=%d\n",  gsw_font_size);      /* font_size */
    fprintf(fd, "filter=%s\n",     gsw_filter);         /* filter (compatibility only!) */

    fclose(fd);
}



int gsw_sort_game_description(void) {
    gsw_data_t  xchg;
    int     i,
            j,
            sorted = 0;

    for(i = 0; i < (gsw_tot - 1); i++) {
        for(j = i + 1; j < gsw_tot; j++) {
            if(stricmp(gsw_data[j].full, gsw_data[i].full) < 0) {
                xchg        = gsw_data[j];
                gsw_data[j] = gsw_data[i];
                gsw_data[i] = xchg;
                sorted++;
            }
        }
    }

    return(sorted);
}



void gsweb_loadconf(void) {
    FILE    *fd;
    u_char  buff[32 + GSMAXPATH + 1],
            *val,
            *key,
            *full,
            *path,
            *query,
            *filter,
            *ip,
            *port,
            *pass;

    fprintf(fdout, "- load configuration file %s\n", GSWCFG);

    fd = gslfopen(GSWCFG, "rb");
    if(!fd) {
        fd = gslfopen(GSWCFG, "wb");
        if(!fd) std_err();
        fclose(fd);
        return;
    }

    while(fgets(buff, sizeof(buff), fd)) {
        delimit(buff);

    #define FINDIT(x,y,z)   x = strchr(y, z);   \
                            if(x) {             \
                                *x++ = 0;       \
                            } else {            \
                                x = "";         \
                            }

        FINDIT(val, buff, '=');

        if(!strcmp(buff, "player")) {               /* player */
            MYDUP(gsw_player, val);

        } else if(!strcmp(buff, "game")) {          /* game */
            FINDIT(key,    val,   ';');
            FINDIT(full,   key,   ';');
            FINDIT(path,   full,  ';');
            FINDIT(query,  path,  ';');
            FINDIT(filter, query, ';');

            gsw_data = realloc((u_char *)gsw_data, (gsw_tot + 1) * sizeof(gsw_data_t));
            if(!gsw_data) std_err();
            memset(&gsw_data[gsw_tot], 0, sizeof(gsw_data_t));

            MYDUP(gsw_data[gsw_tot].game,   val);
            MYDUP(gsw_data[gsw_tot].key,    key);
            MYDUP(gsw_data[gsw_tot].full,   full);
            MYDUP(gsw_data[gsw_tot].path,   path);
            gsw_data[gsw_tot].query         = atoi(query);
            MYDUP(gsw_data[gsw_tot].filter, filter);

            gsw_tot++;

        } else if(!strcmp(buff, "fav")) {           /* fav */
            FINDIT(ip,     val,   ';');
            FINDIT(port,   ip,    ';');
            FINDIT(pass,   port,  ';');

            gsw_fav_data = realloc((u_char *)gsw_fav_data, (gsw_fav_tot + 1) * sizeof(gsw_fav_data_t));
            if(!gsw_fav_data) std_err();
            memset(&gsw_fav_data[gsw_fav_tot], 0, sizeof(gsw_fav_data_t));

            MYDUP(gsw_fav_data[gsw_fav_tot].game, val);
            gsw_fav_data[gsw_fav_tot].ip          = resolv(ip);
            gsw_fav_data[gsw_fav_tot].port        = atoi(port);
            MYDUP(gsw_fav_data[gsw_fav_tot].pass, pass);

            gsw_fav_tot++;

        } else if(!strcmp(buff, "filter")) {        /* filter (compatibility only!) */
            MYDUP(gsw_filter, val);

        } else if(!strcmp(buff, "maxping")) {       /* ping */
            gsw_maxping = atoi(val);

        } else if(!strcmp(buff, "noping")) {        /* noping */
            gsw_noping = atoi(val);

        } else if(!strcmp(buff, "maxservers")) {    /* maxservers */
            gsw_maxservers = atoi(val);

        } else if(!strcmp(buff, "font_size")) {     /* font size */
            gsw_apply_font(atoi(val));
        }
    }

    #undef FINDIT

    fclose(fd);
    fprintf(fdout, "- %d games loaded and configured\n", gsw_tot);
    fprintf(fdout, "- %d favorites loaded and configured\n", gsw_fav_tot);

    if(gsw_sort_game_description()) gsweb_saveconf();
}



int gsw_game_exists(u_char *value) {
    int     i;

    for(i = 0; i < gsw_tot; i++) {
        if(!strcmp(gsw_data[i].game, value)) return(i);
    }
    return(-1);
}



int gsw_read_cfg_value(u_char *fname, u_char *game, u_char *parcmp, u_char *buff, int max, FILE *fd) {
    int     type,
            found = 0;
    u_char  *par,
            *val;

    if(fname) {
        fd = gslfopen(fname, "rb");
        if(!fd) return(0);
    } else {
        rewind(fd); // fast solution
    }

    while((type = myreadini(fd, buff, max, &par, &val)) >= 0) {
        if(!type) {             /* gamename */
            if(found) break;
            if(!strcmp(par, game)) found++;
        } else if(found) {      /* parameter/value */
            if(!strcmp(par, parcmp)) break;
        }
    }

    if(fname) fclose(fd);

    if(val) return(mystrcpy(buff, val, max));
    return(0);
}



int gsw_substitute(u_char *buff, int bufflen, u_char *from, u_char *to, int add_apex) {
    u_char  *p;
    int     fromlen = strlen(from),
            tolen   = strlen(to);

    while((p = (u_char *)stristr(buff, from))) {    // case insensitive
        if(add_apex && (*(p - 1) != '\"') && (p[fromlen] != '\"')) {
            memmove(p + 1 + tolen + 1, p + fromlen, bufflen + 1);
            *p++ = '\"';
            memcpy(p, to, tolen);
            *(p + tolen) = '\"';
            tolen += 2;
        } else {
            memmove(p + tolen, p + fromlen, bufflen + 1);
            memcpy(p, to, tolen);
        }
        bufflen += (tolen - fromlen);
    }
    return(bufflen);
}



u_char *gsw_http_value(u_char *req, u_char *par, u_char *value) {
    u_char  *p;

    *(u_char **)par   = NULL;
    *(u_char **)value = NULL;

    p = strchr(req, '?');   /* par */
    if(p) {
        p++;
    } else {
        p = req;
    }
    *(u_char **)par = p;

    p = strchr(p, '=');     /* value */
    if(!p) return(NULL);
    *p++ = 0;
    *(u_char **)value = p;

    p = strchr(p, '&');     /* next */
    if(!p) return(NULL);
    *p++ = 0;
    return(p);
}



void gsw_http2chr(u_char *data, int len) {
    int     chr;
    u_char  *out;

    for(out = data; len; out++, data++, len--) {
        if(*data == '%') {
            sscanf(data + 1, "%02x", &chr);
            *out = chr;
            len  -= 2;
            data += 2;
            continue;
        } else if(*data == '+') {
            *out = ' ';
        } else {
            *out = *data;
        }
    }
    *out = 0;
}



void gsweb_update(int sock) {
    GSWSEND(GSWDEFAULT3);
    GSWSEND(GSWUPDATE1);

    gsfullup_aluigi();
    if(
      (cool_download(FULLCFG,   ALUIGIHOST, 80, "papers/" FULLCFG) < 0) ||
      (cool_download(DETECTCFG, ALUIGIHOST, 80, "papers/" DETECTCFG) < 0)) {
        if(cool_download(KNOWNCFG, HOST, 28900, "software/services/index.aspx") > 0) {
            verify_gamespy();
        }
        cool_download(DETECTCFG, HOST, 28900,   "software/services/index.aspx?mode=detect");
    }

    GSWSEND(GSWUPDATE2);
}



void gsweb_update_aluigi(int sock) {
    GSWSEND(GSWDEFAULT3);
    GSWSEND(GSWUPDATE1);

    gsfullup_aluigi();
    cool_download(FULLCFG,   ALUIGIHOST, 80, "papers/" FULLCFG);
    cool_download(DETECTCFG, ALUIGIHOST, 80, "papers/" DETECTCFG);

    GSWSEND(GSWUPDATE2);
}



void gsweb_show_bottom(int sock, u_char *game, int servers, u_char *psa) {
    int     i,
            thisone = 0;
    u_char  *filter = "";

    for(i = 0; i < gsw_tot; i++) {
        if(strcmp(gsw_data[i].game, game)) continue;
        filter  = gsw_data[i].filter;
        thisone = i;
        break;
    }

    tcpspr(sock,
        "</table>"  // not closed before
        "%s"
        "<td width=\"12%%\">%s</td>"
        "<td width=\"12%%\">hosts %d</td>"
        "<td width=\"12%%\">filter %s</td>"
        "<td width=\"64%%\">"
        "<form action=\"list\" method=\"get\">"
        "<select name=\"game\">",
        GSWDEFAULT1,
        game,
        servers,
        *filter ? "<b>ON</b>" : "off");

    for(i = 0; i < gsw_tot; i++) {
        tcpspr(sock,
            "<option value=\"%s\"%s>%s",
            gsw_data[i].game,
            (i == thisone) ? " selected" : "",
            gsw_data[i].full);
    }

    tcpspr(sock,
        "</select>"
        " sort: "
        "<select name=\"sort\">"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s"
        "<option value=\"%d\">%s",
        GSW_SORT_PING,  "ping",
        GSW_SORT_NAME,  "name",
        GSW_SORT_MAP,   "map",
        GSW_SORT_TYPE,  "type",
        GSW_SORT_PLAYER,"players",
        GSW_SORT_VER,   "version",
        GSW_SORT_MOD,   "mod",
        GSW_SORT_DED,   "dedicated",
        GSW_SORT_PWD,   "password",
        GSW_SORT_PB,    "punkbuster",
        GSW_SORT_RANK,  "ranked",
        GSW_SORT_MODE,  "mode");

    if(gsw_refresh.len) {
        tcpspr(sock,
            "</select>"
            "<input type=\"submit\" value=\"LIST\">"
            "<input type=\"hidden\" name=\"game\" value=\"%s\">"
            " "
            "<input type=\"submit\" name=\"refresh\" value=\"REPING\">"
            "</form>"
            "</td>"
            "</tr>"
            "</table>"
            "%s"
            "<td align=\"center\">%s</td>"
            "</tr>",
            game,
            GSWDEFAULT1,
            psa);
    } else {
        tcpspr(sock,
            "</select>"
            "<input type=\"submit\" value=\"LIST\">"
            "</form>"
            "</td>"
            "</tr>"
            "</table>"
            "%s"
            "<td align=\"center\">%s</td>"
            "</tr>",
            GSWDEFAULT1,
            psa);
    }
}



void gsweb_index(int sock) {
    GSWSEND(gsw_skin_games);
    gsweb_show_bottom(sock, "", 0, "");
}



void gsweb_show_ipport(int sock, u_char *game, ipdata_t *gip, u_char *pass, int favport) {
    int     gyr = 0;    // 0 = g, 1 = y, 2 = r
    u_char  mypass[64],
            myfav[256],
            *ipc,
            *entryc   = "",
            *playersc = "",
            *modec    = "",
            *ded      = "",
            *pwd      = "",
            *pwdc     = "",
            *pb       = "",
            *pbc      = "",
            *rank     = "";

#define GREEN   " class=\"g\""
#define YELLOW  " class=\"y\""
#define RED     " class=\"r\""
#define BLUE    " class=\"b\""

    ipc = inet_ntoa(*(struct in_addr *)&gip->ip);
    if((gip->ded == '1')  || ((gip->ded | 0x20) == 't')) {
        ded = "D";
    }
    if((gip->pwd == '1')  || ((gip->pwd | 0x20) == 't')) {
        pwd  = "P";
        pwdc = YELLOW;
        gyr  = 1;
    }
    if((gip->pb  == '1')  || ((gip->pb  | 0x20) == 't')) {
        pb  = "B";
        pbc = BLUE;
//        gyr = 1;
    }
    if((gip->rank == '1') || ((gip->rank | 0x20) == 't')) {
        rank = "R";
    }
    if(!gip->players) {
        playersc = YELLOW;
        gyr = 1;
    } else if(gip->players >= gip->max) {
        playersc = RED;
        gyr = 2;
    }
    if(!gip->max) {
        playersc = RED;
        gyr = 2;
    }
    if(gip->mode && strstr(gip->mode, "close")) {
        modec = RED;
        gyr = 2;
    }
    if(gyr == 1) {
        entryc = YELLOW;
    } else if(gyr == 2) {
        entryc = RED;
    }

    if(pass && *pass) {
        mysnprintf(mypass, sizeof(mypass), HTTPAMP "pass=%s", pass);
    } else {
        *mypass = 0;
    }

    if(favport) {
        mysnprintf(myfav, sizeof(myfav),
//            "<form action=\"fav\" method=get>"
//            "<input type=\"hidden\" name=\"ip\" value=\"%s\">"
//            "<input type=\"hidden\" name=\"port\" value=\"%hu\">"
//            "<input type=\"submit\" name=\"rem\" value=\"R\">"
//            "</form>",
            "<a href=\"fav?ip=%s" HTTPAMP "port=%hu" HTTPAMP "rem=1\"><b>X</b></a> ",
            ipc, favport);
        // favport is REQUIRED because sometimes the query port is different than the game port...
    } else {
        *myfav = 0;
    }

    tcpspr(sock,
        "<tr>"
        "<td%s>%s<a href=\"play?game=%s" HTTPAMP "ip=%s" HTTPAMP "port=%hu" "%s" "\">%s:%hu</a></td>"
        "<td>%s</td>"           // name
        "<td>%s</td>"           // map
        "<td>%s</td>"           // type
        "<td%s>%hhu/%hhu</td>"  // players
        "<td>%s</td>"           // version
        "<td>%s</td>"           // mod
        "<td>%s</td>"           // dedicated
        "<td%s>%s</td>"         // password
        "<td%s>%s</td>"         // punkbuster
        "<td>%s</td>"           // ranked/rated
        "<td%s>%s</td>"         // mode
        "<td>%u</td>"           // ping
        "</tr>",
        entryc, myfav, game, ipc, ntohs(gip->port), mypass, ipc, ntohs(gip->port),
        gip->name   ? gip->name : (u_char *)"",
        gip->map    ? gip->map  : (u_char *)"",
        gip->type   ? gip->type : (u_char *)"",
        playersc, gip->players,
        gip->max,
        gip->ver    ? gip->ver  : (u_char *)"",
        gip->mod    ? gip->mod  : (u_char *)"",
        ded,
        pwdc, pwd,
        pbc, pb,
        rank,
        modec, gip->mode ? gip->mode : (u_char *)"",
        gip->ping);

#undef GREEN
#undef YELLOW
#undef RED
#undef BLUE
}



void gsweb_join(int sock, u_char *req) {
    ipdata_t    *gip;
    ipport_t    ipport;
    u_int   ping    = gsw_maxping;
    int     i,
            query   = -1,
            thisone = 0;
    u_short port    = 0;
    u_char  tmpquery[GSWQUERYSZ + 1],
            *p,
            *par,
            *value,
            *game   = "",
            *ip     = NULL,
            *pass   = "";

    if(req) {
        p = req;
        do {
            p = gsw_http_value(p, (u_char *)&par, (u_char *)&value);
            if(!value) break;

            if(!strcmp(par, "ip")) {
                ip = value;

            } else if(!strcmp(par, "port")) {
                port = atoi(value);

            } else if(!strcmp(par, "game")) {
                game = value;

            } else if(!strcmp(par, "ping")) {
                ping = atoi(value);

            } else if(!strcmp(par, "query")) {
                query = atoi(value);

            } else if(!strcmp(par, "pass")) {
                pass = value;
            }
        } while(p);
    }

    GSWSEND(GSWDEFAULT3);

    for(i = 0; i < gsw_tot; i++) {
        if(strcmp(gsw_data[i].game, game)) continue;
        thisone = i;
        break;
    }

    GSWSEND(
        "<tr>"
        "<td>"
        "IP:PORT");

    tcpspr(sock,        /* PING */
        "<form action=\"join\" method=get>"
        "<input type=\"text\" name=\"ip\" value=\"%s%s%s\" size=21>"
        "%s"
        "<input type=\"submit\" value=\"PING\">"
        "</form>",
        ip   ? ip           : (u_char *)"",
        port ? ":"          : "",
        port ? myitoa(port) : (u_char *)"",
        gsw_calc_query(tmpquery, 0));

    tcpspr(sock,        /* PING2 */
        "<form action=\"join\" method=get>"
        "<input type=\"text\" name=\"ip\" value=\"%s%s%s\" size=21>"
        "<select name=\"game\">",
        ip   ? ip           : (u_char *)"",
        port ? ":"          : "",
        port ? myitoa(port) : (u_char *)"");

    for(i = 0; i < gsw_tot; i++) {
        tcpspr(sock,
            "<option value=\"%s\"%s>%s",
            gsw_data[i].game,
            (i == thisone) ? " selected" : "",
            gsw_data[i].full);
    }

    GSWSEND(
        "</select>"
        "<input type=\"submit\" value=\"PING\">"
        "</form>"
    );

    tcpspr(sock,        /* JOIN */
        "<form action=\"play\" method=get>"
        "<input type=\"text\" name=\"ip\" value=\"%s%s%s\" size=21>"
        "<select name=\"game\">",
        ip   ? ip           : (u_char *)"",
        port ? ":"          : "",
        port ? myitoa(port) : (u_char *)"");

    for(i = 0; i < gsw_tot; i++) {
        tcpspr(sock,
            "<option value=\"%s\"%s>%s",
            gsw_data[i].game,
            (i == thisone) ? " selected" : "",
            gsw_data[i].full);
    }

    GSWSEND(
        "</select>"
        "<input type=\"password\" name=\"pass\" value=\"\" size=20>"
        "<input type=\"submit\" value=\"JOIN\">"
        "</form>"
    );

    tcpspr(sock,        /* FAV */
        "<form action=\"fav\" method=get>"
        "<input type=\"text\" name=\"ip\" value=\"%s%s%s\" size=21>"
        "<select name=\"game\">",
        ip   ? ip           : (u_char *)"",
        port ? ":"          : "",
        port ? myitoa(port) : (u_char *)"");

    for(i = 0; i < gsw_tot; i++) {
        tcpspr(sock,
            "<option value=\"%s\"%s>%s",
            gsw_data[i].game,
            (i == thisone) ? " selected" : "",
            gsw_data[i].full);
    }

    GSWSEND(
        "</select>"
        "<input type=\"password\" name=\"pass\" value=\"\" size=20>"
        "<input type=\"submit\" name=\"add\" value=\"FAVORITE\">"
        "</form>"
    );

    GSWSEND("</td></tr>");

    if(!ip) return;

    p = strchr(ip, ':');
    if(p) {
        *p = 0;
        port = atoi(p + 1);
    }

    if(!port) {
        GSWSEND("<br>No valid port specified, use IP:PORT<br>");
        return;
    }
    if(query < 0) {
        if(!*game) return;
        query = gsw_get_query_for_game(game);
    }

    GSWSEND(gsw_skin_games);

    ipport.ip   = resolv(ip);
    ipport.port = htons(port);

    gip = calloc(2, sizeof(ipdata_t));
    if(!gip) std_err();

    multi_scan(query, &ipport, 1, gip, ping);
    if(gip[0].sort == IPDATA_SORT_CLEAR) gip[0].ping = 0;
    gsweb_show_ipport(sock, game, &gip[0], "", 0);

    free_ipdata(gip, 2);

    GSWSEND("</table>");
}



void gsweb_fav(int sock, u_char *req) {
    ipdata_t    *gip;
    ipport_t    ipport;
    int     i,
            query,
            op      = 0;
    u_short port    = 0;
    u_char  *p,
            *par,
            *value,
            *game   = "",
            *ip     = NULL,
            *pass   = "";

    if(req) {
        p = req;
        do {
            p = gsw_http_value(p, (u_char *)&par, (u_char *)&value);
            if(!value) break;

            if(!strcmp(par, "ip")) {
                ip = value;

            } else if(!strcmp(par, "port")) {
                port = atoi(value);

            } else if(!strcmp(par, "game")) {
                game = value;

            } else if(!strcmp(par, "pass")) {
                pass = value;

            } else if(!strcmp(par, "add")) {
                op = 1;

            } else if(!strcmp(par, "rem")) {
                op = 2;
            }
        } while(p);

        p = strchr(ip, ':');
        if(p) {
            *p = 0;
            port = atoi(p + 1);
        }

        if(!ip || !port) return;

        if(op == 1) {
            gsw_fav_data = realloc((u_char *)gsw_fav_data, (gsw_fav_tot + 1) * sizeof(gsw_fav_data_t));
            if(!gsw_data) std_err();
            memset(&gsw_fav_data[gsw_fav_tot], 0, sizeof(gsw_fav_data_t));

            MYDUP(gsw_fav_data[gsw_fav_tot].game, game);
            gsw_fav_data[gsw_fav_tot].ip          = resolv(ip);
            gsw_fav_data[gsw_fav_tot].port        = port;
            MYDUP(gsw_fav_data[gsw_fav_tot].pass, pass);

            gsw_fav_tot++;
            gsweb_saveconf();

        } else if(op == 2) {
            for(i = 0; i < gsw_fav_tot; i++) {
                if((gsw_fav_data[i].ip == resolv(ip)) && (gsw_fav_data[i].port == port)) break;
            }
            if(i < gsw_fav_tot) {
                gsw_fav_tot--;
                if(i != gsw_fav_tot) {
                    memmove(&gsw_fav_data[i], &gsw_fav_data[gsw_fav_tot], sizeof(gsw_fav_data_t));
                }
                gsweb_saveconf();
            }
        }
    }

    GSWSEND(gsw_skin_games);

    gip = calloc(2, sizeof(ipdata_t));
    if(!gip) std_err();

    for(i = 0; i < gsw_fav_tot; i++) {
        ipport.ip   = gsw_fav_data[i].ip;
        ipport.port = htons(gsw_fav_data[i].port);
        query       = gsw_get_query_for_game(gsw_fav_data[i].game);

        multi_scan(query, &ipport, 1, gip, gsw_maxping);
        if(gip[0].sort == IPDATA_SORT_CLEAR) gip[0].ping = 0;
        gsweb_show_ipport(sock, gsw_fav_data[i].game, &gip[0], gsw_fav_data[i].pass, gsw_fav_data[i].port);
    }

    free_ipdata(gip, 2);
}



void gsweb_list(int sock, u_char *req) {
    ipdata_t    *gip;
    struct  sockaddr_in peer;
    u_int   ping;
    int     i,
            servers   = 0,
            sd,
            err,
            len,
            dynsz,
            query,
            refresh   = 0,
            sort_type = GSW_SORT_PING,
            free_servers;
    u_char  *buff     = NULL,
            psa[280],
            *game     = "",
            *gamekey  = "",
            *filter   = "",
            validate[43],
            secure[65],
            *p,
            *sec,
            *key,
            *par,
            *value,
            *ipbuff;

    if(!req) {
        gsweb_index(sock);
        return;
    }

    ping  = gsw_maxping;
    query = -1;
    p     = req;
    do {
        p = gsw_http_value(p, (u_char *)&par, (u_char *)&value);
        if(!value) break;

        if(!strcmp(par, "game")) {
            if(*value) game = value;

        } else if(!strcmp(par, "ping")) {
            ping = atoi(value);

        } else if(!strcmp(par, "query")) {
            query = atoi(value);

        } else if(!strcmp(par, "key")) {
            gamekey = value;

        } else if(!strcmp(par, "filter")) {
            filter = value;

        } else if(!strcmp(par, "refresh")) {
            refresh = 1;

        } else if(!strcmp(par, "sort")) {
            sort_type = atoi(value);
        }
    } while(p);

    if(!game || !*game) goto quit;

    i = gsw_game_exists(game);
    if(i < 0) {
        if(query < 0) query = 0;    /* default \status\ */
    } else {
        if(!*game)    game   = gsw_data[i].game;
        if(query < 0) query  = gsw_data[i].query;
        if(!*filter)  filter = gsw_data[i].filter;
    }

    if(gsw_allow_refresh && refresh && gsw_refresh.game && !strcmp(gsw_refresh.game, game)) {
        len    = gsw_refresh.len;
        ipbuff = gsw_refresh.buff;
        goto scanner;
    } else {
        refresh = 0;
        if(gsw_refresh.buff) free(gsw_refresh.buff);
        gsw_refresh.game = NULL;
        gsw_refresh.buff = NULL;
        gsw_refresh.len  = 0;
    }

    peer.sin_addr.s_addr = gsw_msip;
    peer.sin_port        = htons(msport);
    peer.sin_family      = AF_INET;

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer)) < 0) {
        if(!quiet) fputs("- connection refused\n", fdout);
        goto quit;
    }

    buff = malloc(BUFFSZ + 1);
    if(!buff) std_err();
    dynsz = BUFFSZ;

    sec = recv_basic_secure(sd, buff, BUFFSZ);
    if(sec) {
        STRCPY(secure, sec);
        key = gsseckey(validate, sec, msgamekey, enctype);
        free(sec);
    } else {
        key = "";
        *secure = 0;
    }

    if(tcpspr(sd,
        PCK,
        msgamename,
        enctype,
        key,
        game,
        filter[0] ? "\\where\\" : "",
        filter[0] ? filter      : (u_char *)""
    ) < 0) std_err();

    printf("- gamename: %s\n", game);

    len = 0;
    while((err = recv(sd, buff + len, dynsz - len, 0)) > 0) {
        len += err;
        if(len >= dynsz) {
            dynsz += BUFFSZ;
            buff = realloc(buff, dynsz);
            if(!buff) std_err();
        }
    }
    close(sd);

    ipbuff = buff;
    if(!enctype) {
        if(!strncmp(buff + len - 7, "\\final\\", 7)) len -= 7;

    } else if((enctype == 1) && len) {
        ipbuff = enctype1_decoder(secure, buff, &len);

    } else if((enctype == 2) && len) {
        ipbuff = enctype2_decoder(msgamekey, buff, &len);
    }

scanner:
    GSWSEND(gsw_skin_games);

    if(!len) goto quit;

    servers = (len / 6) + 1;                    /* +1 is needed for zeroing the latest IP! */
    free_servers = servers;
    gip = calloc(servers, sizeof(ipdata_t));    /* calloc for zeroing everything */
    if(!gip) std_err();

    if(gsw_maxservers && (gsw_maxservers < servers) && !quiet) {
        fprintf(fdout, "- limit warning: ping %d servers\n", servers);
    }

    servers = multi_scan(query, ipbuff, servers - 1, gip, ping);

    if(gsw_allow_refresh && !refresh) {
        if(gsw_refresh.buff) free(gsw_refresh.buff);
        gsw_refresh.buff = malloc(len);
        if(!gsw_refresh.buff) std_err();
        memcpy(gsw_refresh.buff, ipbuff, len);
        MYDUP(gsw_refresh.game, game);
        gsw_refresh.len  = len;
    }
    if(buff) free(buff);

    if(gsw_maxservers && (gsw_maxservers < servers)) {
        servers = gsw_maxservers;
    }

    gsw_sort_IP(gip, servers, sort_type);
    for(i = 0; i < servers; i++) {
        if(gsw_noping && (gip[i].sort == IPDATA_SORT_CLEAR)) continue;
        gsweb_show_ipport(sock, game, &gip[i], "", 0);
    }

    free_ipdata(gip, free_servers);

quit:
    if(!gsw_read_cfg_value(DETECTCFG, game, "PSA", psa, sizeof(psa), NULL)) {
        *psa = 0;
    }

    gsweb_show_bottom(sock, game, servers, psa);
}



void gsweb_play(int sock, u_char *req, int localip) {
    int     i = -1,
            len,
            ret;
    u_char  buff[FULLSZ + 128],
            *exe,
            *p,
            *l,
            *par,
            *value,
            *ip   = NULL,
            *port = NULL,
            *pass = NULL;

    if(!req) {
        gsweb_index(sock);
        return;
    }

    p = req;
    do {
        p = gsw_http_value(p, (u_char *)&par, (u_char *)&value);
        if(!value) break;

        if(!strcmp(par, "game")) {
            i = gsw_game_exists(value);

        } else if(!strcmp(par, "ip")) {
            ip = value;

        } else if(!strcmp(par, "port")) {
            port = value;

        } else if(!strcmp(par, "pass")) {   /* works but is manual for the moment! */
            pass = value;
        }
    } while(p);

    if(!ip || !port || (i < 0)) {
        gsweb_index(sock);
        return;
    }

    exe = strrchr(gsw_data[i].path, PATH_SLASH);
    if(exe) {
        *exe = 0;
        ret = chdir(gsw_data[i].path);
        *exe = PATH_SLASH;
        if(ret < 0) {
            tcpspr(sock,
                "<br><br>Error while entering in the game folder: %s<br>",
                gsw_data[i].path);
            return;
        }
        exe++;
    } else {
        exe = gsw_data[i].path;
    }
#ifndef WIN32
    p = malloc(strlen(exe) + 3);
    sprintf(p, "./%s", exe);
    exe = p;
#endif

    GSWSEND(GSWDEFAULT3);

    len = gsw_read_cfg_value(FULLCFG, gsw_data[i].game, "jointemplate", buff, FULLSZ, NULL);
    if(len) {
        len = gsw_substitute(buff, len, "#EXEPATH#",     exe,        1);
        len = gsw_substitute(buff, len, "#SERVERIP#",    ip,         0);
        len = gsw_substitute(buff, len, "#SERVERPORT#",  port,       0);
        len = gsw_substitute(buff, len, "#PLAYERNAME#",  gsw_player, 1);
        len = gsw_substitute(buff, len, "#PLAYER#",      gsw_player, 1);

            /* NOT YET SUPPORTED!!! */
        len = gsw_substitute(buff, len, "#LOCALIP#",     "",         0);
        len = gsw_substitute(buff, len, "#ALLIPS#",      "",         0);
        len = gsw_substitute(buff, len, "#GAMEVARIANT#", "",         1);
        len = gsw_substitute(buff, len, "#ROOMNAME#",    "",         1);
        len = gsw_substitute(buff, len, "#GROUPID#",     "",         1);
        len = gsw_substitute(buff, len, "#PLAYEREMAIL#", "",         1);
        len = gsw_substitute(buff, len, "#PLAYERPID#",   "",         1);
        len = gsw_substitute(buff, len, "#PLAYERPW#",    "",         1);
        len = gsw_substitute(buff, len, "#PASSWORD#",    "",         1);
        len = gsw_substitute(buff, len, "#GPNAME#",      "",         1);
        len = gsw_substitute(buff, len, "#CHATNAME#",    "",         1);
        len = gsw_substitute(buff, len, "#GAMETYPE#",    "",         1);
        len = gsw_substitute(buff, len, "#MAXCLIENTS#",  "",         1);
        len = gsw_substitute(buff, len, "#GAMETYPECMD#", "",         1);

        // #RULE(gamever)#
        // #RULE('gamever')#
        // #REGVAL(HKEY_LOCAL_MACHINE\Software\Monolith Productions\Aliens vs. Predator 2\1.0\InstallDir)#

        p = strstr(buff, "[$SERVERPW$");
        if(p) {
            if(pass) {
                memmove(p, p + 11, (len + 1) - 11);
                len = gsw_substitute(buff, len - 11, "#SERVERPW#", pass,  1);
                l = strchr(p, ']');
                if(l) {
                    memmove(l, l + 1, (len + 1) - (l - buff));
                    len--;
                }
            } else {
                l = strchr(p, ']');
                if(l) {
                    l++;
                } else {
                    l = buff + len;
                }
                memmove(p, l, (len + 1) - (l - buff));
                len -= (l - p);
            }
        }

    } else {
        if(!quiet) fprintf(fdout, "- this game doesn't support direct IP join, I launch the game\n");
        len = sprintf(buff, "\"%s\"", exe);
    }

#ifndef WIN32
    free(exe);
#endif

    if(localip && !quiet) fprintf(fdout, "- Execute: %s\n", buff);
    send(sock, buff, len, 0);

    if(!localip) return;

    p = strchr(buff + 1, '\"');
    if(p != (buff + 1)) {

#ifdef WINTRAY
        if(p) {
            p++;
            *p = 0;
            p++;
        }

        ret = (int)ShellExecute(
            NULL,
            "open",
            buff,
            p,
            NULL,
            EXESHOW);
#else
        strcat(buff, " &");
        ret = system(buff);
#endif

        tcpspr(sock, "<br><br>Return code %d<br>", ret);
    }
}



void gsweb_show_filter_option(int sock, u_char *name, u_char *val1, u_char *op, u_char *val2) {
    tcpspr(sock,    // lame solution, consider it a work-around
        "<tr>"
        "<td><b>%s</b></td>"
        "<td><input type=\"hidden\" name=\"op\" value=\"%s\"></td>"
        "<td><input type=\"checkbox\" name=\"%s\" value=\"%s\"></td>"
        GSWFILTERX,
        name,
        op,
        val1,
        val2);
}



void gsweb_show_filter(int sock, u_char *name, int type) {
#define TEXT1   "<option value=\"LIKE\">equal"          \
                "<option value=\"NOT LIKE\">different"
#define TEXT2   "<option value=\"&gt;\">major"          \
                "<option value=\"&lt;\">minor"          \
                "<option value=\"=\">equal"             \
                "<option value=\"!=\">different"        \
                "<option value=\"&gt;=\">major equal"   \
                "<option value=\"&lt;=\">minor equal"

    tcpspr(sock,
        "<tr>"
        "<td><b>%s</b></td>"
        "<td>"
        "<select name=\"op\">"
        "%s"
        "</select>"
        "</td>"
        "<td><input type=\"text\" name=\"%s\" size=33></td>"
        GSWFILTERX,
        name,
        type ? TEXT2 : TEXT1,
        name);

#undef TEXT1
#undef TEXT2
}



void gsweb_set_filter(int sock, u_char *req) {
    int     i,
            mlen;
    u_char  *p,
            *f,
            *par,
            *value,
            *op;

    if(req) {
        mlen = strlen(req);
        p = req;
        do {
            p = gsw_http_value(p, (u_char *)&par, (u_char *)&value);
            if(!value) break;

            if(!strcmp(par, "full")) {
                MYDUP(gsw_filter, value);
                continue;
            }

            if(gsw_filter) free(gsw_filter);
            gsw_filter = malloc((mlen * 3) + 1);    /* not really right */
            if(!gsw_filter) std_err();

            f = gsw_filter;
            *f++ = '(';
            op = value;         /* avoid errors */
            do {
                if(!strcmp(par, "op")) {
                    op = value;
                    if(!*op) op = "==";

                } else if(!strcmp(par, "more") && *value) {
                    if((*(f - 1) == ')')) {
                        f += sprintf(f, " %s ", value);
                    }

                } else if(*value && (*(value + 1) != '\'')) {
                    f += sprintf(f,
                        "(%s %s %s%s%s)",
                        par, op,
                        (*op >= 'A') ? "'" : "",
                        value,
                        (*op >= 'A') ? "'" : "");
                }
                if(!p) break;
                p = gsw_http_value(p, (u_char *)&par, (u_char *)&value);
            } while(value);

            if(*(f - 1) == '(') {
                f--;
            } else {
                if(*(f - 1) == ' ') {
                    for(f--; *f != ')'; f--);
                    f++;
                }
                *f++ = ')';
            }
            *f = 0;
        } while(p);
    }

    GSWSEND(GSWDEFAULT3);

    tcpspr(sock,
        "%s"
        "%s"
        "<b>current filter</b><br>"
        "you can set it manually with the following entry or using the various options below<br>"
        "<input type=\"text\" name=\"full\" value=\"%s\" size=64>"
        "%s"
        "%s"
        "%s",
        GSWFILTER1,
        GSWFILTER2,
        gsw_filter,
        GSWFILTER3,
        GSWDEFAULT2,
        GSWFILTER2);

    gsweb_show_filter(sock, "hostaddr",  0);
    gsweb_show_filter(sock, "hostport",  1);
    gsweb_show_filter(sock, "gamever",   1);

    GSWSEND(
        "<tr>"
        "<td><b>country</b></td>"
        "<td></td>"
        "<td>"
        "<input type=\"hidden\" name=\"op\" value=\"LIKE\">"
        "<select name=\"country\">");

    for(i = 0; countries[i][0]; i++) {
        tcpspr(sock,
            "<option value=\"%s\">%s",
            (*countries[i][0] != '[') ? countries[i][0] : "",
            countries[i][1]);
    }

    GSWSEND("</select></td>");
    GSWSEND(GSWFILTERX);

    gsweb_show_filter(sock, "hostname",   0);
    gsweb_show_filter(sock, "mapname",    0);
    gsweb_show_filter(sock, "gametype",   0);
    gsweb_show_filter(sock, "gamemode",   0);
    gsweb_show_filter(sock, "numplayers", 1);
    gsweb_show_filter(sock, "maxplayers", 1);
    gsweb_show_filter_option(sock, "no empty",       "numplayers",    ">",  "0");
    gsweb_show_filter_option(sock, "no full",        "numplayers",    "<",  "maxplayers");
    gsweb_show_filter_option(sock, "no password*",   "password",      "!=", "1");
    gsweb_show_filter_option(sock, "no punkbuster*", "sv_punkbuster", "!=", "1");
    gsweb_show_filter_option(sock, "punkbuster*",    "sv_punkbuster", "==", "1");

    GSWSEND(GSWFILTER4);
}



void gsw_config_form(int sock, u_char *msg, u_char *name, u_char *value, int input_size) {
    tcpspr(sock,
        "<tr>"
        "<td>"
        "<b>%s</b>"
        "<form action=\"config\" method=get>"
        "<input type=\"text\" name=\"%s\" value=\"%s\" size=%d>"
        "<input type=\"submit\" value=\"save\">"
        "</form>"
        "<br>"  // useful
        "</td>"
        "</tr>",
        msg,
        name,
        value,
        input_size);
}



void gsw_config_form_game(int sock, int pos) {
    u_char  tmpquery[GSWQUERYSZ + 1];

    tcpspr(sock,
        "<tr>"
        "<td>"
        "<br>"  // useful
        "<center><b>%s</b></center>"
        "<form action=\"config\" method=get>"
        "<input type=\"hidden\" name=\"game\" value=\"%s\">"
        "<input type=\"text\" name=\"path\" value=\"%s\" size=50> executable's path<br>"
        "<input type=\"file\" size=30> find the game's executable and paste the link in the above path entry<br>"
        "%s query<br>"
        "<input type=\"text\" name=\"filter\" value=\"%s\" size=100> filter currently in use for this game<br>"
        "<input type=\"submit\" name=\"filter\" value=\"%s\"> apply the current temporary <a href=\"filter\">filter</a><br>"
        "<input type=\"submit\" name=\"filter\" value=\"\"> reset the game's filter<br>"
        "<input type=\"submit\" name=\"remove\" value=\"remove\">"
        "<input type=\"submit\" value=\"save\"> confirm here the changes for this game entry"
        "</form>"
        "<br>"  // useful
        "</td>"
        "</tr>",
        gsw_data[pos].full,
        gsw_data[pos].game,
        gsw_data[pos].path,
        gsw_calc_query(tmpquery, gsw_data[pos].query),
        gsw_data[pos].filter,
        gsw_filter);
}



void gsweb_config(int sock, u_char *req) {
    int     i = -1,
            saveme = 0;
    u_char  *p,
            *par,
            *value;

    if(req) {
        p = req;
        do {
            p = gsw_http_value(p, (u_char *)&par, (u_char *)&value);
            if(!value) break;

            if(!strcmp(par, "player")) {
                MYDUP(gsw_player, value);
                saveme++;

            } else if(!strcmp(par, "game")) {
                i = gsw_game_exists(value);
                if(i < 0) continue;

            } else if(!strcmp(par, "path")) {
                if(i < 0) continue;
                MYDUP(gsw_data[i].path, value);
                saveme++;

            } else if(!strcmp(par, "query")) {
                if(i < 0) continue;
                gsw_data[i].query  = atoi(value);
                saveme++;

            } else if(!strcmp(par, "filter")) {
                if(i < 0) continue;
                MYDUP(gsw_data[i].filter, value);
                saveme++;

            } else if(!strcmp(par, "remove")) {
                if(i < 0) continue;
                gsw_tot--;
                if(i != gsw_tot) {
                    memmove(&gsw_data[i], &gsw_data[gsw_tot], sizeof(gsw_data_t));
                    gsw_sort_game_description();
                }
                saveme++;

            } if(!strcmp(par, "maxping")) {
                gsw_maxping = atoi(value);
                saveme++;

            } if(!strcmp(par, "noping")) {
                atoi(value) ? (gsw_noping = 1) : (gsw_noping = 0);
                saveme++;

            } if(!strcmp(par, "maxservers")) {
                gsw_maxservers = atoi(value);
                saveme++;

            } if(!strcmp(par, "font_size")) {
                gsw_apply_font(atoi(value));
                saveme++;
            }
        } while(p);
    }

    if(saveme) gsweb_saveconf();

    GSWSEND(GSWDEFAULT4);

    gsw_config_form(sock,
        "Player name",
        "player",
        gsw_player,
        64);

    for(i = 0; i < gsw_tot; i++) {
        gsw_config_form_game(sock, i);
    }

    gsw_config_form(sock,
        "Max ping timeout in seconds",
        "maxping",
        myitoa(gsw_maxping),
        10);

    gsw_config_form(sock,
        "set to 1 for not showing the unpingable (no replies) servers",
        "noping",
        myitoa(gsw_noping),
        10);

    gsw_config_form(sock,
        "Max servers visualized (0 for no limit)",
        "maxservers",
        myitoa(gsw_maxservers),
        10);

    gsw_config_form(sock,
        "Font size",
        "font_size",
        myitoa(gsw_font_size),
        10);
}



int gsw_game_cmp(u_char *s1, u_char *s2) {
    while(*s1) {
        if(*s1 != *s2) return(1);
        s1++;
        s2++;
    }
    return(0);
}



int gsw_get_query(u_char *game, FILE *fastfd) {
    u_char  tmp[FULLSZ + 1],
            tmpgame[CNAMELEN + 1],
            *p;

    STRCPY(tmpgame, game);
    p = tmpgame + strlen(tmpgame) - 3;
    if(!strcmp(p, "ps2")) strcpy(p, "pc");

    if(gsw_read_cfg_value(fastfd ? NULL : FULLCFG, tmpgame, "serverclass", tmp, sizeof(tmp), fastfd) ||
       gsw_read_cfg_value(fastfd ? NULL : FULLCFG, tmpgame, "veserverclass", tmp, sizeof(tmp), fastfd)) {
        if(!strcmp(tmp, "qr2")) {
            return(8);
        } else if(!strcmp(tmp, "quake3")) {
            return(1);
        } else if(!strcmp(tmp, "doom3")) {
            return(6);
        } else if(!strcmp(tmp, "halflife")) {
            return(4);
        } else if(!strcmp(tmp, "source")) {
            return(9);
        } else if(!strcmp(tmp, "tribes2")) {
            return(10);
        }
    }

    /* work-arounds */
    #define W(x,y)  if(!gsw_game_cmp(x, tmpgame)) return(y);

         W("closecomftf",   8)
    else W("cmr4p",         8)
    else W("cmr5p",         8)
    else W("halflife",      4)
    else W("juiced",        8)
    else W("mclub2",        8)
    else W("mclub3",        8)
    else W("quake3",        1)
    else W("racedriver2",   8)
    else W("source",        9)
    else W("stef1",         1)

    #undef W

    return(0);
}



int gsweb_add_game(u_char *game, u_char *full, u_char *path) {
    if(!game || !full) return(-1);
    if(!path) path = "";
    if(gsw_game_exists(game) >= 0) return(-1);

    gsw_data = realloc((u_char *)gsw_data, (gsw_tot + 1) * sizeof(gsw_data_t));
    if(!gsw_data) std_err();                            /* if the adding fails we will continue  */
    memset(&gsw_data[gsw_tot], 0, sizeof(gsw_data_t));  /* to have an allocated buffer for later */

    MYDUP(gsw_data[gsw_tot].game,   game);
    MYDUP(gsw_data[gsw_tot].path,   path);
    MYDUP(gsw_data[gsw_tot].key,    "");
    MYDUP(gsw_data[gsw_tot].filter, "");

/*
    get_key(game, gsw_data[gsw_tot].key, gsw_data[gsw_tot].full);
  GAMEKEY is no longer supported
  but can be easily re-implemented
  in any moment if needed
*/

    if(full[0]) MYDUP(gsw_data[gsw_tot].full, full);
    if(path)    MYDUP(gsw_data[gsw_tot].path, path);
    gsw_data[gsw_tot].query = gsw_get_query(game, NULL);
    gsw_tot++;

    gsw_sort_game_description(); // sorting
    return(0);
}



void gsweb_add(int sock, u_char *req, int fast) {
    u_char  *p,
            *par,
            *value,
            *game = NULL,
            *full = NULL,
            *path = NULL;

    if(!req) {
        gsweb_index(sock);
        return;
    }

    p = req;
    do {
        p = gsw_http_value(p, (u_char *)&par, (u_char *)&value);
        if(!value) break;

        if(!strcmp(par, "game")) {
            game = value;

        } else if(!strcmp(par, "full")) {
            full = value;

        } else if(!strcmp(par, "path")) {
            path = value;
        }
    } while(p);

    if(!gsweb_add_game(game, full, path)) {
        gsweb_saveconf();
    }

    if(fast) return;
    gsweb_config(sock, NULL);
}



void gsweb_search(int sock, u_char *req) {
    FILE    *fd,
            *fastfd;
    u_char  buff[GSLISTSZ + 1],
            tmpquery[GSWQUERYSZ + 1],
            url[FULLSZ + 1],
            tmpfull[CFNAMELEN + 1],
            *p,
            *f,
            *par,
            *value,
            *game;

    fd = gslfopen(GSLISTCFG, "rb");
    if(!fd) {
        gsweb_update(sock);
        return;
    }

    GSWSEND(GSWDEFAULT1);
    GSWSEND(GSWSEARCHT);

    if(req) {
        p = req;
        req = NULL;
        do {
            p = gsw_http_value(p, (u_char *)&par, (u_char *)&value);
            if(!value) break;

            if(!strcmp(par, "q")) {
                req = value;    // req has a double use here
            }
        } while(p);
    }

    if(!req) goto goto_gsweb_search;

    fastfd = gslfopen(FULLCFG, "rb");   // avoids fopen/fclose
    if(!fastfd) std_err();

    while(fgets(buff, sizeof(buff), fd)) {
        if(stristr(buff, req) || !*req) {
            zero_equal(buff + CFNAMEEND);
            zero_equal(buff + CNAMEEND);
            if(buff[CKEYOFF] > ' ') {
                buff[CKEYOFF + 6] = 0;
            } else {
                buff[CKEYOFF] = 0;
            }
            game = buff + CNAMEOFF;

            if(!gsw_read_cfg_value(NULL, game, "newsurl", url, sizeof(url), fastfd)) {
                *url = 0;
            }

            p = buff + CFNAMEOFF;
            f = tmpfull;
            while(*p) {
                if(*p == ' ') {
                    *f = '+';
                } else {
                    *f = *p;
                }
                p++;
                f++;
            }
            strcpy(tmpfull, buff + CFNAMEOFF);  // required for the spaces
            for(p = tmpfull; *p; p++) {
                if(*p == ' ') *p = '+';
            }

            tcpspr(sock,
                "<tr>"
                "<td>%s</td>"
                "<td>%s</td>"
                "<td>%s</td>"
                "<td><a href=\"add?game=%s"  HTTPAMP "full=%s\">O</a></td>"
                "<td><a href=\"list?game=%s" HTTPAMP "ping=0\">O</a></td>"
                "<td>"
                "<form action=\"list\" method=get>"
                "<input type=\"hidden\" name=\"game\" value=\"%s\">"
                "%s"
                "<input type=\"submit\" value=\"O\">"
                "</form></td>"
                "<td>%s%s%s</td>"
                "</tr>",
                buff + CFNAMEOFF,
                game,
                buff + CKEYOFF,
                game,
                tmpfull,
                game,
                game,
                gsw_calc_query(tmpquery, gsw_get_query(game, fastfd)),
                *url ? "<a href=\"" : "",
                *url ? (char *)url  : "",
                *url ? "\">O</a>"   : "");
        }
    }

    fclose(fastfd);

goto_gsweb_search:
    fclose(fd);
    GSWSEND(gsw_skin_search);
}



void gsweb_scan_dir(u_char *filedir, gsw_scan_data_t *list) {
#ifdef WIN32
    WIN32_FIND_DATA wfd;
    HANDLE  hFind;
    int     i,
            plen;
    char    tcDir[MAX_PATH + 1];

    sprintf(tcDir, "%s\\%n*.*", filedir, &plen);

    hFind = FindFirstFile(tcDir, &wfd);
    if(!hFind) return;

    while(FindNextFile(hFind, &wfd)) {
        if(!strcmp(wfd.cFileName, "..")) continue;

        strcpy(tcDir + plen, wfd.cFileName);

        if(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
            gsweb_scan_dir(tcDir, list);
            continue;
        }

        if(stricmp(wfd.cFileName + strlen(wfd.cFileName) - 4, ".exe")) continue;

        for(i = 0; list[i].game && list[i].exe; i++) {
            if(!stricmp(wfd.cFileName, list[i].exe)) {
                if(!quiet) printf("- %30s %s\n", list[i].game, tcDir);
                gsweb_add_game(list[i].game, list[i].full, tcDir);
                break;
            }
        }
    }
    FindClose(hFind);
#endif
}



void gsweb_scan_drive(int sock, u_char *drive) {
    gsw_scan_data_t *list;
    FILE    *fd;
    u_int   startoff;
    int     i,
            num;

    fd = gslfopen(DETECTCFG, "rb");
    if(!fd) {
        gsweb_update(sock);
        return;
    }

    num  = 500;
    list = malloc((num + 1) * sizeof(gsw_scan_data_t));
    if(!list) std_err();

    i = 0;
    for(;;) {
        startoff = find_config_entry(fd, &list[i].game);
        if(!startoff) break;

        if(!read_config_entry(
            fd,
            startoff,
            "findexename",
            &list[i].exe)) continue;

        read_config_entry(
            fd,
            startoff,
            "commonname",
            &list[i].full);

        if(++i == num) {
            num += 250;
            list = realloc(list, (num + 1) * sizeof(gsw_scan_data_t));
            if(!list) std_err();
        }
    }

    list[i + 1].game = NULL;
    list[i + 1].full = NULL;
    list[i + 1].exe  = NULL;

    gsweb_scan_dir(drive, list);

    fclose(fd);
    free_gsw_scan_data(list, num + 1);
    gsweb_saveconf();
}



void gsweb_scan_registry(int sock) {
#ifdef WIN32
    HKEY    key,
            root;
    FILE    *fd;
    u_int   startoff;
    int     len;
    u_char  tmpgame[CNAMELEN + 1],
            tmpbuff[GSMAXPATH + 1],
            *regpath,
            *fullname,
            *p,
            *tmp,
            *value,
            *save;

    fd = gslfopen(DETECTCFG, "rb");
    if(!fd) {
        gsweb_update(sock);
        return;
    }

    for(;;) {
        startoff = find_config_entry(fd, &tmp);
        if(!startoff) break;

        STRCPY(tmpgame, tmp);
        free(tmp);

        save = read_config_entry(
            fd,
            startoff,
            "findregkey",
            &tmp);
        if(!save) continue;

        p = strchr(save, '\\');
        if(p) *p = 0;
        if(!strcmp(save, "HKEY_CLASSES_ROOT")) {
            root = HKEY_CLASSES_ROOT;
        } else if(!strcmp(save, "HKEY_CURRENT_USER")) {
            root = HKEY_CURRENT_USER;
        } else if(!strcmp(save, "HKEY_LOCAL_MACHINE")) {
            root = HKEY_LOCAL_MACHINE;
        } else if(!strcmp(save, "HKEY_USERS")) {
            root = HKEY_USERS;
        } else if(!strcmp(save, "HKEY_PERFORMANCE_DATA")) {
            root = HKEY_PERFORMANCE_DATA;
        } else if(!strcmp(save, "HKEY_CURRENT_CONFIG")) {
            root = HKEY_CURRENT_CONFIG;
        } else if(!strcmp(save, "HKEY_DYN_DATA")) {
            root = HKEY_DYN_DATA;
        } else {
            continue;
        }

        save = p + 1;
        value = strrchr(save, '\\');
        if(!value) continue;
        *value++ = 0;

        len = RegOpenKeyEx(root, save, 0, KEY_READ, &key);
        free(tmp);
        if(len) continue;

        len = sizeof(tmpbuff) - 1;
        if(!RegQueryValueEx(key, value, NULL, NULL, tmpbuff, (void *)&len)) {
            tmpbuff[len - 1] = '\\';

            read_config_entry(
                fd,
                startoff,
                "addtoregpath",
                &regpath);

            if(regpath) {
                read_config_entry(
                    fd,
                    startoff,
                    "commonname",
                    &fullname);

                if(fullname) {
                    len += mystrcpy(tmpbuff + len, regpath, sizeof(tmpbuff) - len);
                    gsw_substitute(tmpbuff, len, "\\\\", "\\", 0);
                    gsweb_add_game(tmpgame, fullname, tmpbuff);
                    free(fullname);
                }

                free(regpath);
            }
        }

        RegCloseKey(key);
    }

    fclose(fd);
    gsweb_saveconf();
#endif
}



void gsweb_scan_games(int sock, u_char *req) {
#ifdef WIN32
    int     i,
            drives;
    u_char  drvstr[4],
            *p,
            *par,
            *value;

    if(!req) {
        drives = GetLogicalDrives();

        GSWSEND(GSWDEFAULT3);
        GSWSEND(
            "<form action=\"scan\" method=get>"
            "<input type=\"checkbox\" name=\"registry\" value=\"1\" checked>registry<br>");

        for(i = 0; i < 26; i++) {
            if(drives & (1 << i)) {
                sprintf(drvstr, "%c:\\", i + 'a');
                if(GetDriveType(drvstr) != DRIVE_FIXED) continue;
                tcpspr(sock,
                    "<input type=\"checkbox\" name=\"drive\" value=\"%.2s\">%s<br>",
                    drvstr, drvstr);
            }
        }

        GSWSEND("<input type=\"submit\" value=\"scan\"></form>");
        return;
    }

    p = req;
    do {
        p = gsw_http_value(p, (u_char *)&par, (u_char *)&value);
        if(!value) break;

        if(!strcmp(par, "registry")) {
            if(atoi(value)) gsweb_scan_registry(sock);

        } else if(!strcmp(par, "drive")) {
            if(*value) gsweb_scan_drive(sock, value);

        }
    } while(p);

#endif

    gsweb_config(sock, NULL);
}



void gsweb_about(int sock) {
    GSWSEND(GSWDEFAULT3);
    tcpspr(sock,
        gsw_skin_about,
        gslist_path, gslist_path);
}



void gsweb_kick(int sock) {
    GSWSEND(GSWDEFAULT3);
    GSWSEND(GSWKICK);
}



MSTHREAD(client, int sock) {
    int     t,
            len,
            localip = 0;
    u_char  buff[1024],         /* enough for any parameter */
            *req,
            *p,
            *l = NULL;

    if(sock < 0) {  /* local IP: negative = local IP */
        sock = -sock;
        localip = 1;
    }

    p = buff;
    len = sizeof(buff) - 1;
    do {
        t = recv(sock, p, len, 0);
        if(t < 0) goto client_quit;
        if(!t) break;
        p += t;
        *p = 0;
        l = strchr(buff, '\n');
    } while(!l && (len -= t));

    if(!l) goto client_quit;

    gsw_http2chr(buff, l - buff);   /* no XSS checks */

    req = strchr(buff, ' ');
    if(req) {
        *req++ = 0;
    } else {
        req = buff;
    }

    p = strrchr(req, ' ');
    if(p) *p = 0;

    if(!localip && p && !quiet) {
        fprintf(fdout, "  %s\n", req);
    }

    if(*req == '/') req++;  /* req is the request, like /index */
    p = strchr(req, '?');
    if(p) *p++ = 0;         /* p are the parameters */

    GSWSEND(GSWHTTP);
    GSWSEND(gsw_skin_head);
    GSWSEND(gsw_skin_window);

    if(!strcmp(req, "list")) {
        gsweb_list(sock, p);

    } else if(!strcmp(req, "join")) {
        gsweb_join(sock, p);

    } else if(!strcmp(req, "fav")) {
        localip ? gsweb_fav(sock, p)  : gsweb_kick(sock);

    } else if(!strcmp(req, "play")) {
        gsweb_play(sock, p, localip);

    } else if(!strcmp(req, "filter")) {
        localip ? gsweb_set_filter(sock, p) : gsweb_kick(sock);

    } else if(!strcmp(req, "config")) {
        localip ? gsweb_config(sock, p) : gsweb_kick(sock);

    } else if(!strcmp(req, "add")) {
        localip ? gsweb_add(sock, p, 0) : gsweb_kick(sock);

    } else if(!strcmp(req, "search")) {
        gsweb_search(sock, p);

    } else if(!strcmp(req, "scan")) {
        localip ? gsweb_scan_games(sock, p) : gsweb_kick(sock);

    } else if(!strcmp(req, "about")) {
        gsweb_about(sock);

    } else if(!strcmp(req, "update")) {
        localip ? gsweb_update(sock) : gsweb_kick(sock);

    } else if(!strcmp(req, "update_aluigi")) {
        localip ? gsweb_update_aluigi(sock) : gsweb_kick(sock);

    } else if(!strcmp(req, "quit")) {
        if(localip) {
            GSWSEND(gsw_skin_end);
            fputs("- quit Gslist\n", stdout);
            shutdown(sock, 2);
            close(sock);
            if(gsw_data)     free_gsw_data(gsw_data, gsw_tot);
            if(gsw_fav_data) free_gsw_fav_data(gsw_fav_data, gsw_fav_tot);
#ifdef WINTRAY
            Shell_NotifyIcon(NIM_DELETE, &tray);
#endif
            exit(0);
        }
        gsweb_kick(sock);

    } else {
        gsweb_index(sock);
    }

    GSWSEND(gsw_skin_end);

client_quit:
    shutdown(sock, 2);
    close(sock);
    return(0);
}



void gsweb(uint32_t ip, uint16_t port) {
    uint32_t    gsw_localip;
    struct  sockaddr_in peer;
    int     sdl,
            sda,
            psz,
            on = 1;

#ifdef WINTRAY
    int     err;
    u_char  run[40];
#endif

#ifdef WIN32
    DWORD       tid;
    HANDLE      th;
#else
    pthread_t   tid;
    int         th;
#endif

    peer.sin_addr.s_addr = ip;
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    psz                  = sizeof(peer);

#ifdef WINTRAY
    sprintf(run, "http://%s:%hu", inet_ntoa(peer.sin_addr), port);

    sdl = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sdl < 0) std_err();
    err = connect(sdl, (struct sockaddr *)&peer, sizeof(peer));
    close(sdl);
    if(!err) {
        ShellExecute(
            NULL,
            "open",
            run,
            NULL,
            NULL,
            EXESHOW);
        return;
    }
#endif

    sdl = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sdl < 0) std_err();
	if(setsockopt(sdl, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
	  < 0) std_err();
    if(bind(sdl, (struct sockaddr *)&peer, sizeof(peer))
	  < 0) std_err();
    if(listen(sdl, SOMAXCONN)
      < 0) std_err();

    gsweb_initconf();
    gsweb_loadconf();

    printf("\n  Gslist web interface ready\n");
    if(peer.sin_addr.s_addr == htonl(INADDR_ANY)) {
        gsw_localip = resolv("127.0.0.1");
        printf("  Now connect to port %hu\n", port);
    } else {
        gsw_localip = ip;
        printf("  Now connect to http://%s:%hu\n",
            inet_ntoa(peer.sin_addr), port);
    }
    if(gsw_admin_IP) gsw_localip = resolv(gsw_admin_IP);

#ifdef WINTRAY
    gsweb_tray();

    ShellExecute(
        NULL,
        "open",
        run,
        NULL,
        NULL,
        EXESHOW);
#endif

    for(;;) {
        sda = accept(sdl, (struct sockaddr *)&peer, &psz);
        if(sda < 0) std_err();

        if(peer.sin_addr.s_addr == gsw_localip) {
            sda = -sda;

        } else if(!quiet) {
            fprintf(fdout, "  %s:%hu ",
                inet_ntoa(peer.sin_addr),
                ntohs(peer.sin_port));
        }

        MSTHREADX(th, tid, client, sda);
    }

    close(sdl);
}


