/*
    Copyright 2005,2006 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

void handoff2gamekey(u_char *out, u_char *in) {
    out[0] = in[2];
    out[1] = in[4];
    out[2] = in[6];
    out[3] = in[8];
    out[4] = in[10];
    out[5] = in[12];
}



    /* scans full.cfg to know if game already exists */
int check_updates(u_char *game, FILE *fdfull) {
    int     type;
    u_char  buff[FULLSZ + 1],
            *par,
            *val;

    rewind(fdfull);
    while((type = myreadini(fdfull, buff, sizeof(buff), &par, &val)) >= 0) {
        if(type) continue;
        if(!strcmp(game, par)) return(0);
    }
    return(1);
}



void verify_gamespy(void) {
    FILE    *fdsvc,
            *fdfull;
    int     i,
            part,
            firstlen;
    u_char  getfile[GETSZ + 1],
            tot[KNOWNSZ + 1],
            *s,
            *p;

    printf("- open %s\n", KNOWNCFG);
    fdsvc = gslfopen(KNOWNCFG, "rb");
    if(!fdsvc) std_err();

    printf("- update %s\n", FULLCFG);
    fdfull = gslfopen(FULLCFG, "r+b");
    if(!fdfull) {
        printf("- create %s\n", FULLCFG);
        fdfull = gslfopen(FULLCFG, "wb");
        if(!fdfull) std_err();
    }

    firstlen = STRCPY(getfile, "software/services/index.aspx?mode=full&services=");
    part = 0;
    while(!feof(fdsvc)) {
        p = getfile + firstlen;
        i = 0;

        while(fgets(tot, sizeof(tot), fdsvc)) {
            if(tot[0] == '-') continue;

            s = strchr(tot, ' ');
            if(!s) continue;
            *s = 0;

            if(!check_updates(tot, fdfull)) continue;

            p += mystrcpy(p, tot, sizeof(getfile) - (p - getfile));
            if(++i == MAXNAMESREQ) break;
            *p++ = '\\';
        }

        if(!i) break;
        if(*(p - 1) == '\\') p--;
        *p = 0;

        fseek(fdfull, 0, SEEK_END); // append
//        if(http2file(HOST, 28900, getfile, fdfull, 0) <= 0) {
        printf("- download part: %d\n", ++part);
        if(mydown_http2file(
            1,              // download
            HOST,           // host
            28900,          // port
            NULL,           // user
            NULL,           // pass
            NULL,           // referer
            GSUSERAGENT,    // useragent
            NULL,           // cookie
            NULL,           // more_http
            0,              // verbosity
            getfile,        // getstr
            fdfull,         // fd
            NULL,           // filename
            0,              // showhead
            0,              // from
            0,              // tot
            NULL,           // filesize
            NULL            // filedata
        ) <= 0) {
            printf("- update interrupted for errors on the server, retry later or tomorrow\n\n");
            break;
        }
        printf("\n");
        fflush(fdfull);             // flush
    }

    fclose(fdsvc);
    fclose(fdfull);
}



int gslistcfgsort(void) {
    FILE    *fd;
    int     i,
            j,
            res,
            tot;
    u_char  **buff,
            *xchg,
            tmp[GSLISTSZ + 1];

    printf("- open %s\n", GSLISTTMP);
    fd = gslfopen(GSLISTTMP, "rb");
    if(!fd) std_err();

    for(tot = 0; fgets(tmp, sizeof(tmp), fd); tot++);   // count the lines
    rewind(fd);

    buff = malloc(sizeof(u_char *) * tot);  // allocate space for pointers
    if(!buff) std_err();

    for(i = 0; i < tot; i++) {
        fgets(tmp, sizeof(tmp), fd);
        buff[i] = strdup(tmp);
        if(!buff[i]) std_err();
    }
    fclose(fd);

    printf("- build, clean & sort %s\n", GSLISTCFG);
    fd = gslfopen(GSLISTCFG, "wb");
    if(!fd) std_err();

    for(i = 0; i < (tot - 1); i++) {
        for(j = i + 1; j < tot; j++) {
            res = stricmp(buff[j], buff[i]);
            if(!res) {              // removes duplicates
                free(buff[j]);
                buff[j] = buff[tot - 1];
                i--;
                tot--;
                break;
            } else if(res < 0) {    // sort
                xchg    = buff[j];
                buff[j] = buff[i];
                buff[i] = xchg;
            }
        }
    }

    for(i = 0; i < tot; i++) {
        if(!buff[i]) continue;
        fputs(buff[i], fd);
        free(buff[i]);
    }
    free(buff);

    fprintf(fd, "%s%s\n", GSLISTVER, VER);
    fclose(fd);
    return(tot);
}



void build_cfg(void) {
    FILE    *fd,
            *fdcfg,
            *fdtmp;
    int     type;
    u_char  buff[FULLSZ + 1],
            tot[GSLISTSZ + 1],
            *p,
            *gamename = NULL,
            *gamekey  = NULL,
            *par,
            *val;

    printf("- open %s\n", FULLCFG);
    fd = gslfopen(FULLCFG, "rb");
    if(!fd) std_err();

    printf("- build %s\n", GSLISTTMP);
    fdtmp = gslfopen(GSLISTTMP, "wb");
    if(!fdtmp) std_err();

    printf("- copy old database from %s\n", GSLISTCFG);
    fdcfg = gslfopen(GSLISTCFG, "rb");
    if(fdcfg) {
        while(fgets(tot, sizeof(tot), fdcfg)) {
            if(!strncmp(tot, GSLISTVER, sizeof(GSLISTVER) - 1)) continue;
            fputs(tot, fdtmp);
        }
        fclose(fdcfg);
    }

#define GSLISTCFGRESET  memset(tot, ' ', GSLISTSZ - 1)
#define GSLISTCFGPUT    if(tot[0] > ' ') {      \
                            fputs(tot, fdtmp);  \
                            GSLISTCFGRESET;     \
                        }

    GSLISTCFGRESET;
    tot[GSLISTSZ - 1] = '\n';
    tot[GSLISTSZ]     = 0;

    while((type = myreadini(fd, buff, sizeof(buff), &par, &val)) >= 0) {
        if(!type) {
            GSLISTCFGPUT;
            memcpy(tot + CNAMEOFF, par, strlen(par));

        } else if(!stricmp(par, "fullname")) {
            if(strlen(val) > CFNAMELEN) val[CFNAMELEN] = 0;
            memcpy(tot + CFNAMEOFF, val, strlen(val));

        } else if(!stricmp(par, "querygame")) {
            if(strlen(val) > CNAMELEN) val[CNAMELEN] = 0;
            memset(tot + CNAMEOFF, ' ', CNAMELEN);
            memcpy(tot + CNAMEOFF, val, strlen(val));

        } else if(!stricmp(par, "handoff")) {
            handoff2gamekey(tot + CKEYOFF, val);
        }
    }
    GSLISTCFGPUT;   // remaining, this is the only compatible way

    fclose(fd);

    printf("- copy database from %s\n", GSHKEYSCFG);
    fd = gslfopen(GSHKEYSCFG, "rb");
    if(!fd) std_err();

    while(fgets(buff, sizeof(buff), fd)) {  // autoconfig
        if(strncmp(buff, "Description", 11)) continue;
        gamename = strstr(buff, "gamename");
        if(!gamename) continue;
        gamekey  = strstr(buff, "gamekey");
        if(!gamekey) continue;
        break;
    }

    while(fgets(buff, sizeof(buff), fd)) {
        if(*buff == '=') continue;
        if(*buff <= ' ') break;

        p = delimit(buff);
        if((p - buff) > GSLISTSZ) continue;
        GSLISTCFGRESET;

        memcpy(tot + CFNAMEOFF, buff, gamename - buff);
        if(p >= (gamekey + 6)) {
            memcpy(tot + CNAMEOFF,  gamename, gamekey - gamename);
            memcpy(tot + CKEYOFF,   gamekey,  6);
        } else {
            memcpy(tot + CNAMEOFF, gamename, strlen(gamename));
        }

        fputs(tot, fdtmp);
    }

    fclose(fd);
    fclose(fdtmp);

    printf("- the database contains %d total entries\n", gslistcfgsort());

#undef GSLISTCFGRESET
#undef GSLISTCFGPUT
}



int make_gslistcfg(int clean) {
    FILE    *fd;
    int     size1,
            size2;

    printf("- start data files downloading:\n");

    if(clean) {     // unlink all the existent files!
        fd = gslfopen(KNOWNCFG,  "wb");
        if(!fd) std_err();
        fclose(fd);

        fd = gslfopen(FULLCFG,   "wb");
        if(!fd) std_err();
        fclose(fd);

        fd = gslfopen(GSLISTCFG, "wb");
        if(!fd) std_err();
        fclose(fd);
    }

    size1 = cool_download(GSHKEYSCFG, ALUIGIHOST, 80,    "papers/" GSHKEYSCFG);
    printf("\n---\n");

    size2 = cool_download(KNOWNCFG,   HOST,       28900, "software/services/index.aspx");
    printf("\n---\n");

    fd = gslfopen(GSLISTCFG, "rb");
    if(fd) fclose(fd);

    if(!fd || (size1 > 0) || (size2 > 0)) {
        verify_gamespy();
        build_cfg();
    } else {
        printf("- no updates available\n");
    }

    cool_download(DETECTCFG,          HOST,       28900, "software/services/index.aspx?mode=detect");
    printf("\n---\n");

    return(0);
}


